/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.model.part;

import java.awt.Color;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.ModelPartData;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.entity.EntityNPCInterface;

public class ModelEyeData
extends ModelPartData {
    public final int[] eyeColor = new int[2];
    public final int[] pupilColor = new int[2];
    public int centerColor = 0;
    public final int[] browColor = new int[2];
    public long blinkStart = 0L;
    public int browThickness = 4;
    public int eyePos = 1;
    public int skinColor = 11830381;
    public int closed = 0;
    public boolean glint = true;
    public ResourceLocation eyeLeft = new ResourceLocation("moreplayermodels:textures/eyes/eye_0.png");
    public ResourceLocation eyeRight = new ResourceLocation("moreplayermodels:textures/eyes/eye_0.png");
    public ResourceLocation pupilLeft = new ResourceLocation("moreplayermodels:textures/eyes/pupil_0.png");
    public ResourceLocation pupilRight = new ResourceLocation("moreplayermodels:textures/eyes/pupil_0.png");
    public ResourceLocation browLeft = new ResourceLocation("moreplayermodels:textures/eyes/brow_0.png");
    public ResourceLocation browRight = new ResourceLocation("moreplayermodels:textures/eyes/brow_0.png");
    public ResourceLocation glintRes = new ResourceLocation("moreplayermodels:textures/eyes/glint.png");
    private final Random rnd = new Random();
    public boolean activeLeft = true;
    public boolean activeRight = true;
    public boolean activeCenter = false;
    public int ticks = -1;

    public ModelEyeData() {
        super("eyes");
        this.reset();
    }

    public void reset() {
        int v;
        int[] arr = new int[]{new Color(0xE6E6E6).getRGB(), new Color(15089728).getRGB(), new Color(0xE6E6E6).getRGB(), new Color(4253248).getRGB(), new Color(0xE6E6E6).getRGB(), new Color(4210918).getRGB(), new Color(0xE6E6E6).getRGB(), new Color(9610147).getRGB(), new Color(0xE6E6E6).getRGB(), new Color(14474368).getRGB()};
        this.eyeColor[0] = v = arr[this.rnd.nextInt(arr.length)];
        this.eyeColor[1] = v;
        arr = new int[]{new Color(8368696).getRGB(), new Color(16247203).getRGB(), new Color(0xA0A0FF).getRGB(), new Color(0xA7A7A7).getRGB(), new Color(10791096).getRGB(), new Color(0x4040FF).getRGB(), new Color(14188339).getRGB(), new Color(11685080).getRGB(), new Color(6724056).getRGB(), new Color(0xE5E533).getRGB(), new Color(8375321).getRGB(), new Color(15892389).getRGB(), new Color(0x999999).getRGB(), new Color(5013401).getRGB(), new Color(8339378).getRGB(), new Color(3361970).getRGB(), new Color(6704179).getRGB(), new Color(6717235).getRGB(), new Color(0x993333).getRGB(), new Color(16445005).getRGB(), new Color(6085589).getRGB(), new Color(4882687).getRGB(), new Color(55610).getRGB()};
        this.pupilColor[0] = v = arr[this.rnd.nextInt(arr.length)];
        this.pupilColor[1] = v;
        this.centerColor = new Color(0).getRGB();
        arr = new int[]{new Color(5982516).getRGB(), new Color(10395279).getRGB(), new Color(3153936).getRGB(), new Color(16027152).getRGB()};
        this.browColor[0] = v = arr[this.rnd.nextInt(arr.length)];
        this.browColor[1] = v;
        arr = new int[]{new Color(11830381).getRGB(), new Color(5982516).getRGB(), new Color(10395279).getRGB(), new Color(3153936).getRGB(), new Color(16027152).getRGB()};
        this.skinColor = arr[this.rnd.nextInt(arr.length)];
        this.glint = this.rnd.nextFloat() < 0.5f;
        this.activeLeft = this.rnd.nextFloat() > 0.005f;
        this.activeRight = this.rnd.nextFloat() > 0.005f;
        this.activeCenter = this.rnd.nextFloat() > 0.9f;
        v = this.rnd.nextInt(3);
        this.eyeLeft = new ResourceLocation("moreplayermodels:textures/eyes/eye_" + v + ".png");
        this.eyeRight = new ResourceLocation("moreplayermodels:textures/eyes/eye_" + v + ".png");
        v = this.rnd.nextInt(4);
        this.pupilLeft = new ResourceLocation("moreplayermodels:textures/eyes/pupil_" + v + ".png");
        this.pupilRight = new ResourceLocation("moreplayermodels:textures/eyes/pupil_" + v + ".png");
        v = this.rnd.nextInt(4);
        this.browLeft = new ResourceLocation("moreplayermodels:textures/eyes/brow_" + v + ".png");
        this.browRight = new ResourceLocation("moreplayermodels:textures/eyes/brow_" + v + ".png");
    }

    public boolean isEnabled() {
        return this.type >= 0;
    }

    @Override
    public void load(NBTTagCompound compound) {
        if (compound.func_150296_c().isEmpty()) {
            return;
        }
        super.load(compound);
        this.glint = compound.func_74767_n("Glint");
        this.closed = compound.func_150297_b("Closed", 1) ? (compound.func_74767_n("Closed") ? 1 : 0) : compound.func_74762_e("Closed");
        if (this.closed < 0) {
            this.closed *= -1;
        }
        if (this.closed > 3) {
            this.closed = 3;
        }
        this.skinColor = compound.func_74762_e("SkinColor");
        this.eyePos = compound.func_74762_e("PositionY");
        this.browThickness = compound.func_74762_e("BrowThickness");
        if (compound.func_150297_b("ActiveLeft", 1)) {
            this.activeLeft = compound.func_74767_n("ActiveLeft");
        }
        if (compound.func_150297_b("ActiveRight", 1)) {
            this.activeRight = compound.func_74767_n("ActiveRight");
        }
        if (compound.func_150297_b("ActiveCenter", 1)) {
            this.activeCenter = compound.func_74767_n("ActiveCenter");
        }
        if (compound.func_150297_b("EyeColor", 11) && compound.func_74759_k("EyeColor").length > 1) {
            this.eyeColor[0] = compound.func_74759_k("EyeColor")[0];
            this.eyeColor[1] = compound.func_74759_k("EyeColor")[1];
        }
        if (compound.func_150297_b("PupilColor", 11) && compound.func_74759_k("PupilColor").length > 1) {
            this.pupilColor[0] = compound.func_74759_k("PupilColor")[0];
            this.pupilColor[1] = compound.func_74759_k("PupilColor")[1];
        } else {
            this.pupilColor[0] = compound.func_74762_e("Color");
            this.pupilColor[1] = compound.func_74762_e("Color");
        }
        this.centerColor = compound.func_150297_b("CenterColor", 3) ? compound.func_74762_e("CenterColor") : 0;
        if (compound.func_150297_b("BrowColor", 3)) {
            this.browColor[0] = compound.func_74762_e("BrowColor");
            this.browColor[1] = compound.func_74762_e("BrowColor");
        } else if (compound.func_150297_b("BrowColor", 11) && compound.func_74759_k("BrowColor").length > 1) {
            this.browColor[0] = compound.func_74759_k("BrowColor")[0];
            this.browColor[1] = compound.func_74759_k("BrowColor")[1];
        }
        if (compound.func_150297_b("EyeResources", 9)) {
            NBTTagList ress = compound.func_150295_c("EyeResources", 8);
            if (ress.func_74745_c() > 0) {
                this.eyeLeft = new ResourceLocation(ress.func_150307_f(0));
            }
            if (ress.func_74745_c() > 1) {
                this.eyeRight = new ResourceLocation(ress.func_150307_f(1));
            }
            if (ress.func_74745_c() > 2) {
                this.pupilLeft = new ResourceLocation(ress.func_150307_f(2));
            }
            if (ress.func_74745_c() > 3) {
                this.pupilRight = new ResourceLocation(ress.func_150307_f(3));
            }
            if (ress.func_74745_c() > 4) {
                this.browLeft = new ResourceLocation(ress.func_150307_f(4));
            }
            if (ress.func_74745_c() > 5) {
                this.browRight = new ResourceLocation(ress.func_150307_f(5));
            }
        }
    }

    public void update(EntityNPCInterface npc) {
        if (!this.isEnabled() || !npc.func_70089_S() || npc.func_70005_c_().indexOf("1_") != 0 && !npc.func_70613_aW()) {
            return;
        }
        if (this.blinkStart < 0L) {
            ++this.blinkStart;
        } else if (this.blinkStart == 0L) {
            if (npc.field_70128_L || npc.func_70608_bn()) {
                return;
            }
            if (this.rnd.nextInt(150) == 1) {
                this.blinkStart = System.currentTimeMillis();
                Server.sendAssociatedData((Entity)npc, EnumPacketClient.EYE_BLINK, npc.func_145782_y());
            }
        } else if (System.currentTimeMillis() - this.blinkStart > 300L) {
            this.blinkStart = -20L;
        }
    }

    @Override
    public NBTTagCompound save() {
        NBTTagCompound compound = super.save();
        compound.func_74757_a("Glint", this.glint);
        compound.func_74768_a("Closed", this.closed);
        compound.func_74768_a("SkinColor", this.skinColor);
        compound.func_74768_a("PositionY", this.eyePos);
        compound.func_74768_a("BrowThickness", this.browThickness);
        compound.func_74783_a("EyeColor", this.eyeColor);
        compound.func_74783_a("PupilColor", this.pupilColor);
        compound.func_74768_a("CenterColor", this.centerColor);
        compound.func_74783_a("BrowColor", this.browColor);
        compound.func_74757_a("ActiveLeft", this.activeLeft);
        compound.func_74757_a("ActiveRight", this.activeRight);
        compound.func_74757_a("ActiveCenter", this.activeCenter);
        NBTTagList resources = new NBTTagList();
        resources.func_74742_a((NBTBase)new NBTTagString(this.eyeLeft.toString()));
        resources.func_74742_a((NBTBase)new NBTTagString(this.eyeRight.toString()));
        resources.func_74742_a((NBTBase)new NBTTagString(this.pupilLeft.toString()));
        resources.func_74742_a((NBTBase)new NBTTagString(this.pupilRight.toString()));
        resources.func_74742_a((NBTBase)new NBTTagString(this.browLeft.toString()));
        resources.func_74742_a((NBTBase)new NBTTagString(this.browRight.toString()));
        compound.func_74782_a("EyeResources", (NBTBase)resources);
        return compound;
    }
}

